
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_EST_ALCADA_CP_COB]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_EST_ALCADA_CP_COB]
GO  

CREATE FUNCTION [dbo].[UFD_EST_PROD_EST_ALCADA_CP_COB]  (@CD_EMP  INT,      													
														 @CD_PROD INT,
														 @CD_SIGLA	INT )  
            
 
 RETURNS @RS_TAB_LIMITE TABLE ( CD_EMP			INT,
								CD_PROD			INT,  
								PARAM_LIMITE	MONEY,   
								TP_NIVEL		INT)  
  
WITH ENCRYPTION AS                
BEGIN                
          

DECLARE @RS_DADOS_TBL_LIMITE AS TABLE ( PARAM_LIMITE	MONEY,   
										TP_NIVEL		INT)  

 

 -------------------------------------------------------------------------------------------------------------------------------      
 --DECLARANDO TABELA DE ARVORE MERCADOLOGICA DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------      
 DECLARE @EST_PROD_ARV_MERC TABLE (   CD_EMP     INT,      
									  CD_PROD   INT,      
									  CD_ARV_MERC_CATEG INT,      
									  CD_ARV_MERC_SEG INT,      
									  CD_ARV_MERC_PAPEL INT,      
									  CD_ARV_MERC_MIX INT,      
									  CD_ARV_MERC_CONSUMO INT,      
									  CD_ARV_MERC_LINHA INT,      
									  CD_ARV_MERC_MTZ_BCG INT,      
									  CD_MC   INT,      
									  CD_ARV_MERC_FAMILIA INT,              
									  CD_APRES   INT,          
									  CD_ARV_MERC_EQUI INT,      
									  CD_GRP_EXPO  INT,      
									  CD_FABRIC   INT)      
      
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --BUSCANDO ARVORE MERC. DO PRODUTO      
 -------------------------------------------------------------------------------------------------------------------------------       
	INSERT INTO @EST_PROD_ARV_MERC      
	SELECT       
		ARV.CD_EMP     ,      
		ARV.CD_PROD     ,      
		ARV.CD_ARV_MERC_CATEG  ,      
		ARV.CD_ARV_MERC_SEG   ,      
		ARV.CD_ARV_MERC_PAPEL  ,      
		ARV.CD_ARV_MERC_MIX   ,      
		ARV.CD_ARV_MERC_CONSUMO  ,      
		ARV.CD_ARV_MERC_LINHA  ,      
		ARV.CD_ARV_MERC_MTZ_BCG  ,      
		ARV.CD_MC     ,      
		ARV.CD_ARV_MERC_FAMILIA  ,              
		ARV.CD_APRES    ,          
		ARV.CD_ARV_MERC_EQUI  ,      
		ARV.CD_GRP_EXPO    ,      
		P.CD_FABRIC       
	FROM 
		EST_PROD_EST_ARV_MERCADOLOGICA ARV 
		INNER JOIN EST_PROD P ON      
		ARV.CD_EMP  = P.CD_EMP      
		AND ARV.CD_PROD = P.CD_PROD      
	WHERE   
		P.CD_EMP = @CD_EMP       
		AND P.CD_PROD = @CD_PROD;
           
                     
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de LIMITE no NVEL 1 - PRODUTOS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		    
		A.PARAM_LIMITE,  
		1 AS TP_NIVEL      
	FROM 		
		EST_ALCADA_CP_COB_CURVA_EST_PROD A        
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND      
		A.CD_PROD = ARV.CD_PROD     
	WHERE 
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T);      
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de LIMITE no NVEL 2 - FAMLIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		   
		A.PARAM_LIMITE,
		2 AS TP_NIVEL      
	FROM 
		EST_ALCADA_CP_COB_CURVA_EST_ARV_MERC_FAMILIA A     
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND      
		A.CD_ARV_MERC_FAMILIA = ARV.CD_ARV_MERC_FAMILIA   
	WHERE
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T);			 
          
 -------------------------------------------------------------------------------------------------------------------------------          
 --Consultando as tbls de LIMITE no NVEL 3 - MARCAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		  
		A.PARAM_LIMITE AS PARAM_LIMITE,      
		3 AS TP_NIVEL      
	FROM 
		EST_ALCADA_CP_COB_CURVA_EST_MC A
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 		
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND      
		A.CD_MC = ARV.CD_MC      		        
	WHERE       		
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T);      	
      
 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de LIMITE no NVEL 4 - FABRICANTES      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		    
		A.PARAM_LIMITE AS PARAM_LIMITE,     
		4 AS TP_NIVEL      
	FROM 
		EST_ALCADA_CP_COB_CURVA_EST_PROD_FABRIC A
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 				
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND      
		A.CD_FABRIC = ARV.CD_FABRIC                
	WHERE       		
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T); 
					
					
 ------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de LIMITE no NVEL 5 - LINHAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		  
		A.PARAM_LIMITE AS PARAM_LIMITE,      
		5 AS TP_NIVEL      
	FROM 
		EST_ALCADA_CP_COB_CURVA_EST_ARV_MERC_LINHA A  
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 				
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND         
		A.CD_ARV_MERC_LINHA = ARV.CD_ARV_MERC_LINHA      
	WHERE       
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T);      

 -------------------------------------------------------------------------------------------------------------------------------      
 --Consultando as tbls de LIMITE no NVEL 6 - CATEGORIAS      
 -------------------------------------------------------------------------------------------------------------------------------      
	INSERT INTO @RS_DADOS_TBL_LIMITE       
	SELECT TOP 1      		  
		A.PARAM_LIMITE AS PARAM_LIMITE,      
		6 AS TP_NIVEL      
	FROM 
		EST_ALCADA_CP_COB_CURVA_EST_ARV_MERC_CATEGORIA A      
		INNER JOIN EST_ALCADA_CP_COB C ON 
		A.CD_CTR = C.CD_CTR 				
		INNER JOIN @EST_PROD_ARV_MERC ARV ON      
		A.CD_EMP = ARV.CD_EMP AND      
		A.CD_ARV_MERC_CATEG = ARV.CD_ARV_MERC_CATEG      		
	WHERE       		       
		C.TP_ALCADA = 0
		AND A.CD_SIGLA = @CD_SIGLA
		AND NOT EXISTS (SELECT T.TP_NIVEL 
					FROM @RS_DADOS_TBL_LIMITE T);       
 
 
    
	INSERT INTO @RS_TAB_LIMITE   
	SELECT TOP 1 
		@CD_EMP,  
		@CD_PROD,		
		PARAM_LIMITE,   
		TP_NIVEL  		
	FROM 
		@RS_DADOS_TBL_LIMITE A  
	ORDER BY 
		TP_NIVEL ASC  
  
RETURN  
  
END        
  